# 機能設計書 1-C#コンパイラ (csc)

## 概要

本ドキュメントは、RoslynプラットフォームにおけるC#コンパイラ (csc) の機能設計について記述する。cscは、C#ソースコードをIL (Intermediate Language/中間言語) にコンパイルするためのコマンドラインツールである。

### 本機能の処理概要

**業務上の目的・背景**：C#コンパイラは、.NETエコシステムにおける中核的な開発ツールであり、開発者が記述したC#ソースコードを実行可能なILコードに変換する役割を担う。Visual StudioやMSBuildなどのビルドシステムから呼び出され、アプリケーションのビルドプロセスの中心となる。従来のネイティブコンパイラからRoslynベースの実装に移行することで、コンパイラAPIの公開や、アナライザーの統合、より高速なインクリメンタルビルドが可能となった。

**機能の利用シーン**：
- コマンドラインからの直接的なC#ソースコードのコンパイル
- MSBuildビルドシステムからのプロジェクトビルド
- Visual Studio IDEでのバックグラウンドコンパイル
- CI/CDパイプラインでの自動ビルド処理
- スクリプト形式のC#ファイルのコンパイル

**主要な処理内容**：
1. コマンドライン引数の解析とオプション設定
2. ソースファイルの読み込みと構文解析 (Parsing)
3. 意味解析 (Semantic Analysis) とシンボル解決
4. コード生成 (IL Emit) とPEファイル出力
5. 診断情報 (警告・エラー) の生成と出力
6. アナライザーの実行とコード品質チェック

**関連システム・外部連携**：
- MSBuildビルドシステムとの統合
- Visual StudioホストオブジェクトAPIとの連携
- Roslynアナライザーとソースジェネレーターの実行基盤

**権限による制御**：特に権限による実行制御は存在しない。ファイルシステムへの読み書き権限のみが必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | なし | - | コマンドラインツールのため画面は存在しない |

## 機能種別

計算処理 / コード変換

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| args | string[] | Yes | コマンドライン引数 | 構文チェック |
| ソースファイル | ファイルパス | Yes | コンパイル対象のC#ソースファイル | ファイル存在確認、拡張子チェック (.cs) |
| /out | string | No | 出力ファイル名 | パス形式チェック |
| /target | string | No | 出力種別 (exe/library/module/winexe) | 列挙値チェック |
| /reference | string[] | No | 参照アセンブリ | ファイル存在確認 |
| /define | string | No | プリプロセッサシンボル | 識別子形式チェック |
| /optimize | bool | No | 最適化の有効化 | - |
| /debug | string | No | デバッグ情報種別 | 列挙値チェック |
| /langversion | string | No | 言語バージョン | サポートバージョンチェック |
| /nullable | string | No | Nullable参照型設定 | 列挙値チェック |
| /unsafe | bool | No | unsafeコードの許可 | - |

### 入力データソース

- C#ソースファイル (.cs)
- レスポンスファイル (.rsp)
- 参照アセンブリ (.dll)
- App.config設定ファイル

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 出力アセンブリ | PE ファイル | コンパイル結果の.dll または .exe |
| PDBファイル | PDB | デバッグシンボル情報 |
| XMLドキュメント | XML | APIドキュメント (オプション) |
| 診断メッセージ | テキスト | エラー・警告メッセージ |
| 終了コード | int | 0=成功、1=失敗 |

### 出力先

- ファイルシステム (指定された出力ディレクトリ)
- 標準出力・標準エラー出力 (診断メッセージ)

## 処理フロー

### 処理シーケンス

```
1. エントリーポイント (Program.Main)
   └─ コマンドライン引数の受け取りとBuildClientへの委譲

2. BuildClient.Run の実行
   └─ コンパイラサーバー接続またはインプロセス実行の判断

3. Csc.Run の呼び出し
   └─ CSharpCompilerインスタンスの生成と実行

4. コマンドライン引数の解析 (CSharpCommandLineParser)
   └─ オプションの解析とCSharpCommandLineArgumentsの生成

5. コンパイル処理 (CreateCompilation)
   └─ ソースファイルの並列パース
   └─ 参照アセンブリの解決
   └─ CSharpCompilationの生成

6. アナライザー実行
   └─ 診断アナライザーの実行
   └─ ソースジェネレーターの実行

7. コード生成 (Emit)
   └─ IL生成とPEファイル出力
   └─ PDBファイル生成

8. 結果出力
   └─ 診断メッセージの出力
   └─ 終了コードの返却
```

### フローチャート

```mermaid
flowchart TD
    A[Program.Main開始] --> B[BuildClient.Run呼び出し]
    B --> C{コンパイラサーバー利用可能?}
    C -->|Yes| D[サーバー経由でコンパイル]
    C -->|No| E[インプロセスでコンパイル]
    D --> F[Csc.Run実行]
    E --> F
    F --> G[コマンドライン解析]
    G --> H{解析成功?}
    H -->|No| I[エラー出力して終了]
    H -->|Yes| J[ソースファイルのパース]
    J --> K[参照の解決]
    K --> L[CSharpCompilation生成]
    L --> M[アナライザー実行]
    M --> N[Emit処理]
    N --> O{コンパイル成功?}
    O -->|Yes| P[終了コード0で終了]
    O -->|No| Q[エラー出力、終了コード1で終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | 言語バージョン制約 | 指定された言語バージョンでサポートされない構文はエラーとなる | 常時 |
| BR-02 | unsafe制約 | unsafeコードは/unsafeオプション指定時のみ許可 | unsafeキーワード使用時 |
| BR-03 | 参照解決順序 | 参照アセンブリは指定順序で解決される | 複数参照指定時 |
| BR-04 | 重複ファイル警告 | 同一ソースファイルが複数回指定された場合は警告 (CS2002) | 重複指定時 |

### 計算ロジック

特になし (変換処理のため)

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作は存在しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| CS0001 | 内部エラー | コンパイラ内部エラー | サポートに連絡 |
| CS0002 | ファイルエラー | ソースファイルが見つからない | ファイルパス確認 |
| CS1001-9999 | 構文/意味エラー | ソースコードの問題 | コード修正 |
| Fatal | 致命的エラー | メモリ不足等 | リソース確保 |

### リトライ仕様

リトライ処理は存在しない。コンパイルは単発実行。

## トランザクション仕様

トランザクション処理は存在しない。

## パフォーマンス要件

- 並列コンパイルオプション (/parallel) による並列処理サポート
- コンパイラサーバーによるウォームスタート
- インクリメンタルコンパイルのサポート

## セキュリティ考慮事項

- unsafeコードの使用は明示的なオプション指定が必要
- 厳格な名前付け (Strong Naming) のサポート
- 署名キーの保護機能

## 備考

- 既定のレスポンスファイル (csc.rsp) は /noconfig オプションで無効化可能
- Visual Studioとの統合時はホストコンパイラオブジェクトを使用

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

コンパイラの入出力を定義するデータ構造から理解を開始する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | CSharpCommandLineArguments.cs | `src/Compilers/CSharp/Portable/CommandLine/CSharpCommandLineArguments.cs` | コマンドライン引数を保持するデータ構造 |
| 1-2 | CSharpCompilationOptions.cs | `src/Compilers/CSharp/Portable/Compilation/CSharpCompilationOptions.cs` | コンパイルオプションの定義 |

**読解のコツ**: CSharpCommandLineArgumentsはCommandLineArgumentsを継承しており、C#固有のオプション（unsafe、nullable等）が追加されている。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイル・関数を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Program.cs | `src/Compilers/CSharp/csc/Program.cs` | コマンドラインエントリーポイント |

**主要処理フロー**:
1. **14-27行目**: Main関数でFileNotFoundExceptionをキャッチしてエラー処理
2. **29-37行目**: MainCoreでCompilerServerLoggerを初期化し、BuildClient.Runを呼び出し
3. **40-41行目**: Runメソッドで外部からの呼び出しをサポート

#### Step 3: コンパイラ本体を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | CSharpCompiler.cs | `src/Compilers/CSharp/Portable/CommandLine/CSharpCompiler.cs` | コンパイラのメインロジック |
| 3-2 | CSharpCommandLineParser.cs | `src/Compilers/CSharp/Portable/CommandLine/CSharpCommandLineParser.cs` | コマンドライン解析 |

**主要処理フロー**:
- **38-171行目**: CreateCompilationメソッドでソースファイルのパースと参照解決を行う
- **58-89行目**: 並列/逐次でのソースファイルパース処理
- **160-170行目**: CSharpCompilation.Createでコンパイルオブジェクト生成

#### Step 4: コンパイル実行を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | CommonCompiler.cs | `src/Compilers/Core/Portable/CommandLine/CommonCompiler.cs` | C#/VB共通のコンパイル処理 |
| 4-2 | CSharpCompilation.cs | `src/Compilers/CSharp/Portable/Compilation/CSharpCompilation.cs` | C#コンパイルの実体 |

### プログラム呼び出し階層図

```
Program.Main
    │
    ├─ BuildClient.Run
    │      │
    │      └─ Csc.Run
    │             │
    │             └─ CSharpCompiler (継承: CommonCompiler)
    │                    │
    │                    ├─ CSharpCommandLineParser.Parse
    │                    │
    │                    ├─ CreateCompilation
    │                    │      │
    │                    │      ├─ ParseFile (並列)
    │                    │      │
    │                    │      └─ CSharpCompilation.Create
    │                    │
    │                    └─ RunCore (CommonCompiler)
    │                           │
    │                           ├─ ResolveAnalyzers
    │                           │
    │                           └─ Emit
    │
    └─ 終了コード返却
```

### データフロー図

```
[入力]                    [処理]                         [出力]

コマンドライン引数  ──▶  CSharpCommandLineParser  ──▶  CSharpCommandLineArguments
        │                                                      │
        ▼                                                      ▼
C#ソースファイル    ──▶  SyntaxFactory.ParseSyntaxTree ──▶  SyntaxTree[]
        │                                                      │
        ▼                                                      ▼
参照アセンブリ      ──▶  ResolveMetadataReferences  ──▶  MetadataReference[]
        │                                                      │
        ▼                                                      ▼
                         CSharpCompilation.Create   ──▶  CSharpCompilation
                                    │
                                    ▼
                         CompilationWithAnalyzers
                                    │
                                    ▼
                              Emit
                                    │
                    ┌───────────────┴───────────────┐
                    ▼                               ▼
            アセンブリファイル (.dll/.exe)      PDBファイル
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Program.cs | `src/Compilers/CSharp/csc/Program.cs` | ソース | コマンドラインエントリーポイント |
| CSharpCompiler.cs | `src/Compilers/CSharp/Portable/CommandLine/CSharpCompiler.cs` | ソース | C#コンパイラ本体 |
| CSharpCommandLineParser.cs | `src/Compilers/CSharp/Portable/CommandLine/CSharpCommandLineParser.cs` | ソース | コマンドライン解析 |
| CSharpCommandLineArguments.cs | `src/Compilers/CSharp/Portable/CommandLine/CSharpCommandLineArguments.cs` | ソース | 引数データ構造 |
| CommonCompiler.cs | `src/Compilers/Core/Portable/CommandLine/CommonCompiler.cs` | ソース | 共通コンパイラ基盤 |
| CSharpCompilation.cs | `src/Compilers/CSharp/Portable/Compilation/CSharpCompilation.cs` | ソース | コンパイルオブジェクト |
| csc.rsp | `src/Compilers/CSharp/csc/csc.rsp` | 設定 | 既定レスポンスファイル |
